// Add person functionality
(function() {
    // Get DOM elements
    var $tableBody = $('#personTable tbody');
    var $form = $('#addPersonForm');
    var $modal = $('#addPersonModal');
    // Add form submission event handler
    $form.on('submit', function(e) {
        // Prevent default form submission
        e.preventDefault();
        // Get the form data (polyfill for IE)
        var formData = new FormData($form[0]);
        // Get age as number
        var age = parseInt(formData.get('age'), 10);
        // If no value entered, set to empty string
        age = isNaN(age) ? '' : age;
        // Add table row element using HTML string
        $tableBody.append('<tr><td>' + formData.get('title').trim() + '</td><td>' + formData.get('fullName').trim() + '</td><td>' + age + '</td><td></td></tr>');
        // Trigger recalculation of money split
        $(window).trigger('update.moneySplit');
        // Close modal
        $modal.modal('hide');
        // Clear form fields
        $form[0].reset();
    });
})();
// Calculate monetary split functionality
(function() {
    // Get DOM elements
    var $tableBody = $('#personTable tbody');
    var $button = $('#calculateMonetarySplit');
    var $monetaryValue = $('#monetarySplitValue');
    // Function to calculate the split
    var calculateSplit = function() {
        // Get the current table rows
        var $tableRows = $tableBody.find('tr');
        // Get the value to split
        var valueToSplit = parseFloat($monetaryValue.val()).toFixed(2);
        // Default to 0
        valueToSplit = isNaN(valueToSplit) ? 0 : valueToSplit;
        // Variable to hold total age
        var totalAge = 0;
        // Loop over each table row
        $tableRows.each(function(index, element) {
            // Increase the total age by this person's age
            var personAge = parseInt($(element).find('td:nth-child(3)').text(), 10);
            // Add age, if none set use 0
            totalAge += (isNaN(personAge) ? 0 : personAge);
        });
        // Calculate the factor
        var factor = valueToSplit / totalAge;
        // Loop over each table row
        $tableRows.each(function(index, element) {
            // Get this person's age
            var personAge = parseInt($(element).find('td:nth-child(3)').text(), 10);
            // If no person age, use 0
            personAge = (isNaN(personAge) ? 0 : personAge);
            // Set the amount they get
            $(element).find('td:last-child').text('£' + (personAge * factor).toFixed(2));
        });
    };
    // Add click event handler
    $button.on('click', function(e) {
        // Prevent default click event
        e.preventDefault();
        // Calculate the split
        calculateSplit();
    });
    // Do recalculation on input change
    $monetaryValue.on('change', calculateSplit);
    // Do recalculation on global event
    $(window).on('update.moneySplit', calculateSplit);
    // Calculate the split
    calculateSplit();
})();